<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>AOOF - Our Services</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/styles.css">
  <link rel="stylesheet" href="css/font-awesome.min.css">
  <link href='http://fonts.googleapis.com/css?family=Poiret+One' rel='stylesheet' type='text/css'>
  <style>
    .services-header { padding: 50px 0; text-align: center; }
    .service-card { padding: 20px; border: 1px solid #ddd; border-radius: 10px; margin-bottom: 30px; transition: transform 0.3s, box-shadow 0.3s; background: #fff; text-align: center; }
    .service-card:hover { transform: translateY(-5px); box-shadow: 0 8px 12px rgba(0,0,0,0.1); }
    .service-icon { width: 70px; height: 70px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px auto; color: #fff; }
    .bg-gradient1 { background: #ff7b7b; }
    .bg-gradient2 { background: #7bb7ff; }
    .bg-gradient3 { background: #7bff9e; }
    .bg-gradient4 { background: #f0a77b; }
    .bg-gradient5 { background: #d77bff; }
  </style>
</head>
<body>

  <!-- Header -->
  <div class="header container">
    <div class="visible-xs visible-sm col-xs-12 col-sm-12 text-center sm-logo">
      <a rel="home" href="index.php">
        <img src="img/logo.png" width="200" alt="logo">
      </a>
    </div>
  </div>

  <!-- Navbar -->
  <div class="navbar" role="navigation">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
      </button>
    </div>
    <div class="collapse navbar-collapse">
      <ul class="nav navbar-nav">
        <li><a href="index.php">Home</a></li>
        <li><a href="about.php">About</a></li>
        <li class="selected"><a href="service.php">Services</a></li>
        <li><a href="gallery.php">Gallery</a></li>
        <li><a href="event.php">Events</a></li>
        <li><a href="team.php">Team</a></li>
        <li><a href="donate.php">Donate</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>

  <!-- Services Header -->
  <section class="services-header">
    <h2>Our Services</h2>
    <p>We deliver impactful programs across health, education, and environmental conservation. Explore our key areas of intervention below.</p>
  </section>

  <!-- Services / Themes Section -->
  <section class="themes-section container">
    <div class="row">
      <!-- Service 1 -->
      <div class="col-sm-12 col-md-6 col-lg-4">
        <div class="service-card">
          <div class="service-icon bg-gradient1"><i class="fa fa-child fa-2x"></i></div>
          <h4>Child Protection & Reintegration</h4>
          <p>Providing dignified living and reintegration support to street-connected children in Kisumu East.</p>
        </div>
      </div>

      <!-- Service 2 -->
      <div class="col-sm-12 col-md-6 col-lg-4">
        <div class="service-card">
          <div class="service-icon bg-gradient2"><i class="fa fa-book fa-2x"></i></div>
          <h4>Education & Learning Equity</h4>
          <p>Supporting schools with resources, life skills programs, and learning equity initiatives.</p>
        </div>
      </div>

      <!-- Service 3 -->
      <div class="col-sm-12 col-md-6 col-lg-4">
        <div class="service-card">
          <div class="service-icon bg-gradient3"><i class="fa fa-heartbeat fa-2x"></i></div>
          <h4>Youth Mental Health & Wellbeing</h4>
          <p>Providing psychosocial support and promoting mental health awareness among youth.</p>
        </div>
      </div>

      <!-- Service 4 -->
      <div class="col-sm-12 col-md-6 col-lg-4">
        <div class="service-card">
          <div class="service-icon bg-gradient4"><i class="fa fa-venus fa-2x"></i></div>
          <h4>Adolescent Health & Dignity</h4>
          <p>Promoting menstrual health, hygiene, and adolescent empowerment programs.</p>
        </div>
      </div>

      <!-- Service 5 -->
      <div class="col-sm-12 col-md-6 col-lg-4">
        <div class="service-card">
          <div class="service-icon bg-gradient5"><i class="fa fa-leaf fa-2x"></i></div>
          <h4>Environmental Protection & Conservation</h4>
          <p>Planting trees, conducting clean-ups, and creating awareness on sustainable environmental practices.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Call-to-action -->
  <section class="container text-center" style="padding:50px 0;">
    <a href="donate.php" class="btn btn-primary btn-lg">Support Our Work</a>
  </section>

  <!-- Footer -->
  <footer id="footer">
    <div class="footer-content container">
      <div class="footer-adress text-center col-xs-12 col-sm-4 col-md-4">
        <h4>Great love for humanity</h4>
        <ul class="footer-menus">
          <li>Home /</li>
          <li>About</li><br />
          <li>Service /</li>
          <li>Gallery /</li>
          <li>Contact</li>
        </ul>
      </div>
      <div class="footer-second col-xs-12 col-sm-4 col-md-4">
        <div class="social-block text-center">
          <div class="social-share">
            <i class="fa fa-2x fa-facebook"></i>
            <i class="fa fa-2x fa-twitter"></i>
            <i class="fa fa-2x fa-google-plus"></i>
            <i class="fa fa-2x fa-instagram"></i>
          </div>
        </div>
        <p class="text-center footer-text1">123 456 7890</p>
        <p class="text-center footer-text">humanity@shuvohabib.com</p>
      </div>
      <div class="footer-third col-xs-12 col-sm-4 col-md-4">
        <div class="copyright text-center">
          <span>&copy; 2025 Theme</span><br>
          <span>All Rights Reserved</span>
        </div>
      </div>
    </div>
  </footer>

  <!-- Scripts -->
  <script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
</body>
</html>
