<?php
// index.php
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>AOOF - Welcome</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

  <!-- CSS -->
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/styles.css"><!-- your custom styles -->
  <link rel="stylesheet" href="css/demo.css">
  <link rel="stylesheet" href="css/testimonial.css">
  <link rel="stylesheet" href="css/font-awesome.min.css">
  <link href="https://fonts.googleapis.com/css?family=Poiret+One" rel="stylesheet" type="text/css">

  <!-- Spinning logo CSS -->
  <style>
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    /* Spinning logo */
    .spinning-logo {
      animation: spin 10s linear infinite;
      display: block;           /* Make it block for centering */
      margin: 0 auto;           /* Center horizontally */
      width: 250px;             /* Default size for navbar */
      height: auto;
    }

    /* Homepage header larger logo */
    .header-logo-large {
      width: 400px;             /* Large version in header */
      height: auto;
    }

    /* Mobile adjustments */
    @media (max-width: 768px) {
      .spinning-logo {
        width: 180px;           /* Smaller logo on mobile */
      }
      .header-logo-large {
        width: 300px;           /* Header mobile size */
      }
    }
  </style>
</head>
<body>

  <!-- Navbar -->
  <div class="navbar" role="navigation">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
      </button>
    </div>
    <div class="collapse navbar-collapse">
      <ul class="nav navbar-nav">
        <li class="selected"><a href="index.php">Home</a></li>
        <li><a href="about.php">About</a></li>
        <li><a href="service.php">Services</a></li>
        <li><a href="gallery.php">Gallery</a></li>
        
        <!-- Desktop logo (hidden-xs hidden-sm) -->
        <li class="hidden-xs hidden-sm text-center">
          <a rel="home" href="index.php">
            <img class="spinning-logo" src="img/logo.jpg" alt="AOOF logo">
          </a>
        </li>

        <li><a href="event.php">Events</a></li>
        <li><a href="team.php">Team</a></li>
        <li><a href="donate.php">Donate</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>

  <!-- Mobile logo (visible-xs visible-sm) -->
  <div class="visible-xs visible-sm col-xs-12 col-sm-12 text-center sm-logo">
    <a rel="home" href="index.php">
      <img class="spinning-logo header-logo-large" src="img/logo.jpg" alt="AOOF logo">
    </a>
  </div>

  <!-- Carousel -->
  <div id="carousel-example-generic" class="carousel slide" data-ride="carousel">
    <ol class="carousel-indicators">
      <li data-target="#carousel-example-generic" data-slide-to="0" class="active"></li>
      <li data-target="#carousel-example-generic" data-slide-to="1"></li>
      <li data-target="#carousel-example-generic" data-slide-to="2"></li>
    </ol>
    <div class="carousel-inner" role="listbox">
      <div class="item active"><img src="img/slide3.jpg" alt=""><div class="carousel-caption">Make Donation</div></div>
      <div class="item"><img src="img/slide2.jpg" alt=""><div class="carousel-caption">Be a Donator</div></div>
      <div class="item"><img src="img/slide1.jpg" alt=""><div class="carousel-caption">Be a volunteer</div></div>
    </div>
    <a class="left carousel-control" href="#carousel-example-generic" role="button" data-slide="prev">
      <span class="glyphicon glyphicon-chevron-left" aria-hidden="true"></span>
      <span class="sr-only">Previous</span>
    </a>
    <a class="right carousel-control" href="#carousel-example-generic" role="button" data-slide="next">
      <span class="glyphicon glyphicon-chevron-right" aria-hidden="true"></span>
      <span class="sr-only">Next</span>
    </a>
  </div>

  <!-- Vision & Mission -->
  <section class="vision-bar">
    <i class="fa fa-eye" aria-hidden="true"></i>
    <p>Our Vision: To create a healthier, more sustainable, and empowered Africa through holistic initiatives.</p>
  </section>

  <section class="mission">
    <i class="fa fa-bullseye" aria-hidden="true"></i>
    <h2>Our Mission</h2>
    <p>We strive to provide impactful programs in health, education, and environmental sustainability, fostering community development and long-term change across Africa.</p>
  </section>

  <!-- Foundation Themes Section -->
  <div class="divider col-sm-12 col-xs-12 col-md-12">
    <div class="header-text">Our <span>Themes</span></div>
  </div>

  <section class="themes-section container">
    <div class="row">
      <?php
      $themes = [
        [
          'icon'=>'fa-child',
          'title'=>'Child Protection & Social Reintegration',
          'text'=>'Provide dignified living to children and reduce street-connected children in Kisumu East through comprehensive care, protection, and reintegration support.',
          'ul'=>[
            'Rescue and safe shelter provision',
            'Access to education and life skills training',
            'Sports and arts for reintegration',
            'Family tracing and psychosocial support'
          ],
          'bg'=>'bg-gradient1'
        ],
        [
          'icon'=>'fa-book',
          'title'=>'Education & Learning Equity',
          'text'=>'Improve learning outcomes in Kisumu County by supporting schools with critical teaching and learning resources.',
          'ul'=>[
            'Provision of textbooks, exercise books, stationery',
            'Sports and arts equipment',
            'Classroom furniture and basic learning aids',
            'ICT integration and teacher support'
          ],
          'bg'=>'bg-gradient2'
        ],
        [
          'icon'=>'fa-heartbeat',
          'title'=>'Youth Mental Health & Psychosocial Wellbeing',
          'text'=>'Enhance mental wellbeing and resilience among youth in Kisumu County through accessible psychosocial support and mental health advocacy.',
          'ul'=>[
            'Mental health awareness campaigns',
            'Peer counselor training',
            'Youth-friendly mental health spaces',
            'Linkages to professional services'
          ],
          'bg'=>'bg-gradient3'
        ],
        [
          'icon'=>'fa-venus',
          'title'=>'Adolescent Health & Dignity',
          'text'=>'Promote menstrual health and hygiene for adolescent girls in Kisumu County to uphold dignity, health, and school attendance.',
          'ul'=>[
            'Distribution of sanitary pads',
            'Menstrual hygiene education',
            'Engagement with boys and men',
            'Advocacy for county-level menstrual health policies'
          ],
          'bg'=>'bg-gradient4'
        ],
        [
          'icon'=>'fa-leaf',
          'title'=>'Environmental Protection & Conservation',
          'text'=>'Improve the natural environment in Kisumu County through tree planting, clean-ups, and education on sustainable practices.',
          'ul'=>[
            'Tree planting initiatives',
            'Community clean-up drives',
            'Environmental education programs',
            'Promotion of renewable energy and sustainability'
          ],
          'bg'=>'bg-gradient5'
        ],
        [
          'icon'=>'fa-users',
          'title'=>'Community Empowerment',
          'text'=>'Strengthen community structures and livelihoods through skills training, micro-enterprise support, and inclusive participation in local decision-making.',
          'ul'=>[
            'Village savings and loan associations',
            'Entrepreneurship & vocational skills training',
            'Support for micro and small enterprises',
            'Civic engagement & leadership development'
          ],
          'bg'=>'bg-gradient6'
        ],
      ];

      $i = 0;
      foreach ($themes as $t): ?>
        <div class="col-xs-12 col-sm-6 col-md-4" data-animate="slide-left">
          <div class="card theme-card h-100 text-dark">
            <div class="card-body d-flex flex-column">
              <div class="theme-icon <?php echo $t['bg']; ?> mb-3">
                <i class="fa <?php echo $t['icon']; ?> fa-2x"></i>
              </div>
              <h5 class="card-title"><?php echo $t['title']; ?></h5>
              <p><?php echo $t['text']; ?></p>
              <ul>
                <?php foreach($t['ul'] as $li) echo "<li>$li</li>"; ?>
              </ul>
              <a href="service.php" class="btn btn-primary mt-auto">Read More</a>
            </div>
          </div>
        </div>

        <?php
          // clearfix after every 2 cards on small screens (>=768px & <992px)
          if ( ($i+1) % 2 === 0 ) echo '<div class="clearfix visible-sm-block"></div>';
          // clearfix after every 3 cards on md+ (>=992px)
          if ( ($i+1) % 3 === 0 ) echo '<div class="clearfix visible-md-block visible-lg-block"></div>';
          $i++;
        ?>
      <?php endforeach; ?>
    </div>
  </section>

  <!-- Metrics Counter -->
  <section class="metrics">
    <div class="metric" data-count="120">
      <div class="metric-number">0</div>
      <div class="metric-label">Projects Completed</div>
    </div>
    <div class="metric" data-count="500">
      <div class="metric-number">0</div>
      <div class="metric-label">Volunteers</div>
    </div>
    <div class="metric" data-count="50">
      <div class="metric-number">0</div>
      <div class="metric-label">Communities Impacted</div>
    </div>
    <div class="metric" data-count="10000">
      <div class="metric-number">0</div>
      <div class="metric-label">Beneficiaries</div>
    </div>
  </section>

  <!-- Testimonials & Newsletter -->
  <div class="divider col-sm-12 col-xs-12 col-md-12">
    <div class="header-text">Our <span>Testimonials</span></div>
  </div>
  <section class="testimonial">
    <div class="col-md-7 testimonial-blog">
      <div id="wrapper">
        <div class="testimonials-slider">
          <div class="slide">
            <div class="testimonials-carousel-thumbnail"><img width="120" alt="" src="images/team1.jpg"></div>
            <div class="testimonials-carousel-context">
              <div class="testimonials-name">Rub elvi <span>shuvohabib.com</span></div>
              <div class="testimonials-carousel-content">
                <p>Sed posuere consectetur est at lobortis. Fusce dapibus, tellus ac cursus commodo.Cras mattis consectetur purus sit amet fermentum. Sed posuere consectetur est at lobortis. Fusce dapibus, tellus ac cursus commodo.</p>
              </div>
            </div>
          </div>
          <div class="slide">
            <div class="testimonials-carousel-thumbnail"><img width="120" alt="" src="images/team2.jpg"></div>
            <div class="testimonials-carousel-context">
              <div class="testimonials-name">Jewel Jahan <span>technextit.com</span></div>
              <div class="testimonials-carousel-content">
                <p>Cras mattis consectetur purus sit amet fermentum. Sed posuere consectetur est at lobortis. Fusce dapibus, tellus ac cursus commodo.</p>
              </div>
            </div>
          </div>
          <div class="slide">
            <div class="testimonials-carousel-thumbnail"><img width="120" alt="" src="images/team3.jpg"></div>
            <div class="testimonials-carousel-context">
              <div class="testimonials-name">Mark Zuckerberg<span>www.Facebook.com</span></div>
              <div class="testimonials-carousel-content">
                <p>It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal..</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="col-md-4 subscribe-form">
      <div class="subscribe">
        <h4>Subscribe to Newsletter</h4>
        <div class="email-field">
          <form action="#">
            <div class="email-input">
              <input type="email" placeholder="Enter your email..." required>
              <i class="fa fa-check col-green"></i>
            </div>
            <button type="submit" class="button-main bg-green">Submit</button>
          </form>
          <span>We never spam :)</span>
        </div>
      </div>
    </div>
  </section>

  <!-- Footer -->
  <footer id="footer">
    <div class="footer-content container">
      <div class="footer-adress text-center col-xs-12 col-sm-4 col-md-4">
        <h4>Great love for humanity</h4>
        <ul class="footer-menus">
          <li>Home /</li>
          <li>About</li><br />
          <li>Service /</li>
          <li>Gallery /</li>
          <li>Contact</li>
        </ul>
      </div>
      <div class="footer-second col-xs-12 col-sm-4 col-md-4">
        <div class="social-block text-center">
          <div class="social-share">
            <i class="fa fa-2x fa-facebook"></i>
            <i class="fa fa-2x fa-twitter"></i>
            <i class="fa fa-2x fa-google-plus"></i>
            <i class="fa fa-2x fa-instagram"></i>
          </div>
        </div>
        <p class="text-center footer-text1">123 456 7890</p>
        <p class="text-center footer-text">abuogofoundation@gmail.com</p>
      </div>
      <div class="footer-third col-xs-12 col-sm-4 col-md-4">
        <div class="copyright text-center">
          <span>&copy; 2025 Abuogo Omboro Owino Foundation</span><br>
          <span>All Rights Reserved</span>
        </div>
      </div>
    </div>
    <div class="move-top-page"></div>
  </footer>

  <!-- Scripts -->
  <script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/nav-hover.min.js"></script>
  <script src="js/jquery.bxslider.min.js"></script>
  <script src="js/main.js"></script>

  <script>
    // Testimonials slider
    $('.testimonials-slider').bxSlider({
      slideWidth: 800,
      minSlides: 1,
      maxSlides: 1,
      slideMargin: 32,
      auto: true,
      autoControls: true
    });

    // Scroll animations
    function handleScrollAnimations() {
      var elements = document.querySelectorAll('[data-animate]');
      var windowHeight = window.innerHeight;
      Array.prototype.forEach.call(elements, function(el){
        var position = el.getBoundingClientRect().top;
        if (position < windowHeight - 100) {
          el.classList.add('in-view');
        }
      });
    }
    window.addEventListener('scroll', handleScrollAnimations);
    window.addEventListener('load', handleScrollAnimations);

    // Counter animation (only update the number)
    $('.metric').each(function () {
      var $num = $(this).find('.metric-number');
      var target = parseInt($(this).data('count'), 10) || 0;
      $({ Counter: 0 }).animate({ Counter: target }, {
        duration: 3000,
        easing: 'swing',
        step: function (now) { $num.text(Math.ceil(now)); }
      });
    });
  </script>
</body>
</html>
