<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>AOOF - Gallery</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/styles.css">
  <link rel="stylesheet" href="css/font-awesome.min.css">
  <link href='http://fonts.googleapis.com/css?family=Poiret+One' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="css/lightbox.min.css">
  <style>
    .gallery-header { padding: 50px 0; text-align: center; }
    .gallery-grid { display: flex; flex-wrap: wrap; gap: 15px; justify-content: center; }
    .gallery-item { width: 300px; overflow: hidden; border-radius: 10px; transition: transform 0.3s, box-shadow 0.3s; }
    .gallery-item img { width: 100%; height: auto; display: block; }
    .gallery-item:hover { transform: scale(1.05); box-shadow: 0 8px 15px rgba(0,0,0,0.2); }
  </style>
</head>
<body>

  <!-- Header -->
  <div class="header container">
    <div class="visible-xs visible-sm col-xs-12 col-sm-12 text-center sm-logo">
      <a rel="home" href="index.php">
        <img src="img/logo.jpg" width="200" alt="logo">
      </a>
    </div>
  </div>

  <!-- Navbar -->
  <div class="navbar" role="navigation">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
      </button>
    </div>
    <div class="collapse navbar-collapse">
      <ul class="nav navbar-nav">
        <li><a href="index.php">Home</a></li>
        <li><a href="about.php">About</a></li>
        <li><a href="service.php">Services</a></li>
        <li class="selected"><a href="gallery.php">Gallery</a></li>
        <li><a href="event.php">Events</a></li>
        <li><a href="team.php">Team</a></li>
        <li><a href="donate.php">Donate</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>

  <!-- Gallery Header -->
  <section class="gallery-header">
    <h2>Our Gallery</h2>
    <p>Browse through moments from our programs, community initiatives, and impactful events across Africa.</p>
  </section>

  <!-- Gallery Grid -->
  <section class="gallery-grid container">
    <div class="gallery-item">
      <a href="img/gallery1.jpg" data-lightbox="foundation-gallery" data-title="Child Protection Program">
        <img src="img/gallery1.jpg" alt="Child Protection">
      </a>
    </div>
    <div class="gallery-item">
      <a href="img/gallery2.jpg" data-lightbox="foundation-gallery" data-title="Education Initiative">
        <img src="img/gallery2.jpg" alt="Education Initiative">
      </a>
    </div>
    <div class="gallery-item">
      <a href="img/gallery3.jpg" data-lightbox="foundation-gallery" data-title="Youth Mental Health">
        <img src="img/gallery3.jpg" alt="Youth Mental Health">
      </a>
    </div>
    <div class="gallery-item">
      <a href="img/gallery4.jpg" data-lightbox="foundation-gallery" data-title="Environmental Conservation">
        <img src="img/gallery4.jpg" alt="Environmental Conservation">
      </a>
    </div>
    <div class="gallery-item">
      <a href="img/gallery5.jpg" data-lightbox="foundation-gallery" data-title="Adolescent Health">
        <img src="img/gallery5.jpg" alt="Adolescent Health">
      </a>
    </div>
    <div class="gallery-item">
      <a href="img/gallery6.jpg" data-lightbox="foundation-gallery" data-title="Community Event">
        <img src="img/gallery6.jpg" alt="Community Event">
      </a>
    </div>
  </section>

  <!-- Footer -->
  <footer id="footer">
    <div class="footer-content container">
      <div class="footer-adress text-center col-xs-12 col-sm-4 col-md-4">
        <h4>Great love for humanity</h4>
        <ul class="footer-menus">
          <li>Home /</li>
          <li>About</li><br />
          <li>Service /</li>
          <li>Gallery /</li>
          <li>Contact</li>
        </ul>
      </div>
      <div class="footer-second col-xs-12 col-sm-4 col-md-4">
        <div class="social-block text-center">
          <div class="social-share">
            <i class="fa fa-2x fa-facebook"></i>
            <i class="fa fa-2x fa-twitter"></i>
            <i class="fa fa-2x fa-google-plus"></i>
            <i class="fa fa-2x fa-instagram"></i>
          </div>
        </div>
        <p class="text-center footer-text1">123 456 7890</p>
        <p class="text-center footer-text">humanity@shuvohabib.com</p>
      </div>
      <div class="footer-third col-xs-12 col-sm-4 col-md-4">
        <div class="copyright text-center">
          <span>&copy; 2025 Theme</span><br>
          <span>All Rights Reserved</span>
        </div>
      </div>
    </div>
  </footer>

  <!-- Scripts -->
  <script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/lightbox.min.js"></script>
</body>
</html>
