<?php // event.php (Bootstrap carousel version) ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Events — AOOF</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

  <!-- CSS -->
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/styles.css">
  <link rel="stylesheet" href="css/demo.css">
  <link rel="stylesheet" href="css/testimonial.css">
  <link rel="stylesheet" href="css/font-awesome.min.css">
  <link href="https://fonts.googleapis.com/css?family=Poiret+One" rel="stylesheet" type="text/css">

  <style>
    /* ------- Page-local polish ------- */
    .header .sm-logo img { width: 260px; height: auto; }
    .navbar .logo { max-height: 72px; width: auto; }

    /* Overview list */
    .blog-event{ display:flex; align-items:flex-start; gap:15px; padding:12px 0; border-bottom:1px solid #eee; }
    .blog-event:last-child { border-bottom:0; }
    .blog-event .featured-img img{ border-radius:6px; }
    .blog-event .featured-blog h3{ margin-top:0; font-size:18px; }
    .button-info{ margin-right:8px; }

    /* Carousel caption */
    .carousel-caption {
      background: rgba(0,0,0,0.45);
      padding: 10px 14px;
      border-radius: 6px;
      font-size: 14px;
      line-height: 1.45;
    }

    /* Tabs */
    #exTab2 { margin-top: 20px; }

    /* Responsive */
    @media (max-width: 768px){
      .blog-event { flex-direction: column; }
      .carousel-caption { font-size: 13px; padding: 8px 10px; }
    }
  </style>
</head>
<body>

  <!-- Header -->
  <div class="header container">
    <div class="visible-xs visible-sm col-xs-12 col-sm-12 text-center sm-logo">
      <a rel="home" href="index.php">
        <img src="img/logo.jpg" width="260" alt="AOOF logo">
      </a>
    </div>
  </div>

  <!-- Navbar -->
  <div class="navbar" role="navigation">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
      </button>
    </div>
    <div class="collapse navbar-collapse">
      <ul class="nav navbar-nav">
        <li><a href="index.php">Home</a></li>
        <li><a href="about.php">About</a></li>
        <li><a href="service.php">Services</a></li>
        <li><a href="gallery.php">Gallery</a></li>
        <li class="hidden-xs hidden-sm">
          <a rel="home" href="index.php"><img class="logo" src="img/logo.jpg" alt="AOOF logo"></a>
        </li>
        <li class="selected"><a href="event.php">Events</a></li>
        <li><a href="team.php">Team</a></li>
        <li><a href="donate.php">Donate</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>

  <!-- Divider -->
  <div class="divider col-sm-12 col-xs-12 col-md-12">
    <div class="header-text">Our <span>Events</span></div>
  </div>

  <div class="container">
    <div class="row">

      <!-- Tabs -->
      <div id="exTab2" class="col-md-8 col-lg-7 col-lg-offset-1 col-md-offset-1">
        <ul class="nav nav-tabs">
          <li class="active"><a href="#1" data-toggle="tab">Overview</a></li>
          <li><a href="#2" data-toggle="tab">Recent Event</a></li>
          <li><a href="#3" data-toggle="tab">Upcoming Event</a></li>
        </ul>

        <div class="tab-content">

          <!-- Overview -->
          <div class="tab-pane active" id="1">
            <div class="blog-event">
              <div class="featured-img">
                <img src="images/clients/1.jpg" width="150" alt="Community meetup">
              </div>
              <div class="featured-blog">
                <h3>Community Drives & Engagement</h3>
                <p>From talks to charity drives to community service, this is where you can find out what’s going on, and sign up!</p>
                <button class="button-info btn btn-default btn-sm">Read More</button>
                <button class="button-info btn btn-primary btn-sm">Register Now</button>
              </div>
            </div>

            <div class="blog-event">
              <div class="featured-img">
                <img src="images/clients/2.jpg" width="150" alt="Workshop">
              </div>
              <div class="featured-blog">
                <h3>Skills Workshops</h3>
                <p>Hands-on learning sessions that empower youth and community members with practical skills.</p>
                <button class="button-info btn btn-default btn-sm">Read More</button>
                <button class="button-info btn btn-primary btn-sm">Register Now</button>
              </div>
            </div>

            <div class="blog-event">
              <div class="featured-img">
                <img src="images/clients/3.jpg" width="150" alt="Clean-up activity">
              </div>
              <div class="featured-blog">
                <h3>Environmental Clean-ups</h3>
                <p>Monthly activities to keep our neighborhoods clean and promote sustainability.</p>
                <button class="button-info btn btn-default btn-sm">Read More</button>
                <button class="button-info btn btn-primary btn-sm">Register Now</button>
              </div>
            </div>
          </div>

          <!-- Recent Event (Bootstrap Carousel) -->
          <div class="tab-pane" id="2">
            <div class="recent-event">
              <h3 class="recent-title">Martin Owino Omboro Memorial Football Tournament — April 2025</h3>

              <div id="eventCarousel" class="carousel slide" data-ride="carousel">
                <!-- Indicators -->
                <ol class="carousel-indicators">
                  <li data-target="#eventCarousel" data-slide-to="0" class="active"></li>
                  <li data-target="#eventCarousel" data-slide-to="1"></li>
                  <li data-target="#eventCarousel" data-slide-to="2"></li>
                  <li data-target="#eventCarousel" data-slide-to="3"></li>
                  <li data-target="#eventCarousel" data-slide-to="4"></li>
                </ol>

                <!-- Slides -->
                <div class="carousel-inner">
                  <div class="item active">
                    <img src="images/events/martin-owino-omboro-2025-04/slide1.jpg" alt="Kickoff match">
                    <div class="carousel-caption">Kickoff — packed stands and great energy.</div>
                  </div>
                  <div class="item">
                    <img src="images/events/martin-owino-omboro-2025-04/slide2.jpg" alt="Teams greet each other">
                    <div class="carousel-caption">Sportsmanship first — teams greet each other.</div>
                  </div>
                  <div class="item">
                    <img src="images/events/martin-owino-omboro-2025-04/slide3.jpg" alt="Quarter-final action">
                    <div class="carousel-caption">Quarter-finals — quick passes and tight defense.</div>
                  </div>
                  <div class="item">
                    <img src="images/events/martin-owino-omboro-2025-04/slide4.jpg" alt="Trophy moment">
                    <div class="carousel-caption">Champions lift the trophy — what a finale!</div>
                  </div>
                  <div class="item">
                    <img src="images/events/martin-owino-omboro-2025-04/slide5.jpg" alt="Community celebration">
                    <div class="carousel-caption">Community together — smiles all around.</div>
                  </div>
                </div>

                <!-- Controls -->
                <a class="left carousel-control" href="#eventCarousel" data-slide="prev">
                  <span class="glyphicon glyphicon-chevron-left"></span>
                </a>
                <a class="right carousel-control" href="#eventCarousel" data-slide="next">
                  <span class="glyphicon glyphicon-chevron-right"></span>
                </a>
              </div>

              <p class="recent-summary">
                The April tournament brought together local teams and supporters to honor Martin Owino Omboro.
                Proceeds supported youth programs and community empowerment. Thanks to all volunteers and partners!
              </p>
            </div>
          </div>

          <!-- Upcoming Event -->
          <div class="tab-pane" id="3">
            <div class="blog-event">
              <div class="featured-img">
                <img src="images/clients/2.jpg" width="150" alt="Upcoming event">
              </div>
              <div class="featured-blog">
                <h3>Upcoming programs</h3>
                <p>Stay tuned for upcoming activities — sports, education, and community clean-ups.</p>
                <button class="button-info btn btn-default btn-sm">Read More</button>
                <button class="button-info btn btn-primary btn-sm">Register Interest</button>
              </div>
            </div>
          </div>

        </div>
      </div>

      <!-- Sidebar -->
      <div id="sidebar" class="col-md-3 col-lg-3">
        <img src="images/child.png" width="100%" alt="Program">
        <h4><a href="#">Enrichment Camps</a></h4>
        <p>Nam consequat lacus purus, ac hendrerit ipsum pellentesque ut. Mauris orci ante, sodales ut lorem sed, semper aliquam diam.</p>
        <div class="progress">
          <div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;">
            <span class="sr-only">60% Complete</span>
          </div>
        </div>

        <img src="images/child2.jpg" width="100%" alt="Family Engagement">
        <h4><a href="#">Family Engagement</a></h4>
        <p>Mauris orci ante, sodales ut lorem sed, semper aliquam diam. Sit amet tellus velit.</p>
        <div class="progress">
          <div class="progress-bar" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%;">
            <span class="sr-only">60% Complete</span>
          </div>
        </div>
      </div>

    </div>
  </div>

  <!-- Footer -->
  <footer id="footer">
    <div class="footer-content container">
      <div class="footer-adress text-center col-xs-12 col-sm-4 col-md-4">
        <h4>Great love for humanity</h4>
        <ul class="footer-menus">
          <li>Home /</li>
          <li>About</li><br />
          <li>Service /</li>
          <li>Gallery /</li>
          <li>Contact</li>
        </ul>
      </div>
      <div class="footer-second col-xs-12 col-sm-4 col-md-4">
        <div class="social-block text-center">
          <div class="social-share">
            <i class="fa fa-2x fa-facebook"></i>
            <i class="fa fa-2x fa-twitter"></i>
            <i class="fa fa-2x fa-google-plus"></i>
            <i class="fa fa-2x fa-instagram"></i>
          </div>
        </div>
        <p class="text-center footer-text1">123 456 7890</p>
        <p class="text-center footer-text">humanity@shuvohabib.com</p>
      </div>
      <div class="footer-third col-xs-12 col-sm-4 col-md-4">
        <div class="copyright">
          <span>&copy; 2025 Theme</span><br>
          <span>All Rights Reserved</span>
        </div>
      </div>
    </div>
    <div class="move-top-page"></div>
  </footer>

  <!-- JS -->
  <script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/nav-hover.min.js"></script>
  <script src="js/main.js"></script>

  <script>
    // Initialize carousel auto-slide every 4 seconds
    $('#eventCarousel').carousel({
      interval: 4000
    });
  </script>
</body>
</html>
