<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>AOOF - About Us</title>
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <link rel="stylesheet" href="css/bootstrap.min.css">
  <link rel="stylesheet" href="css/styles.css">
  <link rel="stylesheet" href="css/font-awesome.min.css">
  <link href='http://fonts.googleapis.com/css?family=Poiret+One' rel='stylesheet' type='text/css'>
  <style>
    /* ===== Core Values & Strategic Sections ===== */
    .core-values h2, .strategic-focus h2, .impact-highlights h2, .mission h2, .vision-bar p {
        font-family: 'Poiret One', cursive;
        margin-bottom: 30px;
    }
    .core-values i, .mission-icon-wrapper i, .vision-icon-wrapper i {
        margin-bottom: 15px;
        color: #3498db;
    }
    .mission, .vision-bar {
        padding: 50px 15px;
        text-align: center;
        background: #f9f9f9;
        margin-bottom: 50px;
        border-radius: 10px;
    }
    .mission h2 { margin-bottom: 20px; }
    .mission p, .vision-bar p { font-size: 1.2em; line-height: 1.6; }
    .impact-highlights img { width: 100%; max-width: 250px; margin: 0 auto; display: block; }
    .impact-highlights h4 { margin-top: 15px; margin-bottom: 10px; font-weight: bold; }
  </style>
</head>
<body>

  <!-- Header -->
  <div class="header container">
    <div class="visible-xs visible-sm col-xs-12 col-sm-12 text-center sm-logo">
      <a rel="home" href="index.php">
        <img src="img/logo.jpg" width="200" alt="logo">
      </a>
    </div>
  </div>

  <!-- Navbar -->
  <div class="navbar" role="navigation">
    <div class="navbar-header">
      <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
        <span class="sr-only">Toggle navigation</span>
        <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
      </button>
    </div>
    <div class="collapse navbar-collapse">
      <ul class="nav navbar-nav">
        <li><a href="index.php">Home</a></li>
        <li class="selected"><a href="about.php">About</a></li>
        <li><a href="service.php">Services</a></li>
        <li><a href="gallery.php">Gallery</a></li>
        <li><a href="event.php">Events</a></li>
        <li><a href="team.php">Team</a></li>
        <li><a href="donate.php">Donate</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
    </div>
  </div>

  <!-- About / Story Section -->
  <section class="about container" style="padding:50px 0;">
    <h2>About Abuogo Owino OMBORO Foundation</h2>
    <p>
      Founded with a vision to create sustainable change, the Abuogo Owino OMBORO Foundation (AOOF) empowers communities in Kisumu and across Africa through health, education, and environmental initiatives. Our programs are designed to provide holistic support, address inequality, and foster long-term community development.
    </p>
  </section>

  <!-- Core Values Section -->
  <section class="core-values container">
    <h2>Our Core Values</h2>
    <div class="row" style="margin-top:30px;">
      <div class="col-md-3 text-center">
        <i class="fa fa-heart fa-3x"></i>
        <h4>Compassion</h4>
        <p>We serve with empathy, ensuring dignity and care for every individual.</p>
      </div>
      <div class="col-md-3 text-center">
        <i class="fa fa-balance-scale fa-3x"></i>
        <h4>Equity</h4>
        <p>Our programs are inclusive, fair, and address systemic inequalities.</p>
      </div>
      <div class="col-md-3 text-center">
        <i class="fa fa-lightbulb-o fa-3x"></i>
        <h4>Innovation</h4>
        <p>We use creative solutions to tackle complex community challenges.</p>
      </div>
      <div class="col-md-3 text-center">
        <i class="fa fa-globe fa-3x"></i>
        <h4>Sustainability</h4>
        <p>Our impact is long-term, promoting environmental and social resilience.</p>
      </div>
    </div>
  </section>

  <!-- Strategic Focus Areas -->
  <section class="strategic-focus container">
    <h2>Strategic Focus Areas</h2>
    <div class="row" style="margin-top:30px;">
      <div class="col-md-4 text-center">
        <h4>Health</h4>
        <p>We implement programs to improve physical and mental health, access to healthcare, and adolescent health and dignity initiatives.</p>
      </div>
      <div class="col-md-4 text-center">
        <h4>Education</h4>
        <p>We enhance learning outcomes, provide resources to schools, and promote literacy, equity, and life skills development.</p>
      </div>
      <div class="col-md-4 text-center">
        <h4>Environment</h4>
        <p>Our initiatives focus on conservation, clean-ups, tree planting, and community awareness on sustainable practices.</p>
      </div>
    </div>
  </section>

  <!-- Impact Highlights -->
  <section class="impact-highlights container">
    <h2>Impact Highlights</h2>
    <div class="row" style="margin-top:30px;">
      <div class="col-md-4 text-center">
        <img src="img/impact1.jpg" alt="Community Health">
        <h4>500+ Beneficiaries</h4>
        <p>Through health programs reaching underserved communities in Kisumu.</p>
      </div>
      <div class="col-md-4 text-center">
        <img src="img/impact2.jpg" alt="Education Support">
        <h4>20 Schools Supported</h4>
        <p>Providing learning materials, furniture, and ICT resources for better learning outcomes.</p>
      </div>
      <div class="col-md-4 text-center">
        <img src="img/impact3.jpg" alt="Environmental Action">
        <h4>10,000 Trees Planted</h4>
        <p>Environmental conservation initiatives creating sustainable communities.</p>
      </div>
    </div>
  </section>

  <!-- Vision Section -->
  <section class="vision-bar">
    <div class="vision-icon-wrapper">
        <i class="fa fa-eye fa-3x" aria-hidden="true"></i>
    </div>
    <p>Our Vision: To create a healthier, more sustainable, and empowered Africa through holistic initiatives.</p>
  </section>

  <!-- Mission Section -->
  <section class="mission">
    <div class="mission-icon-wrapper">
        <i class="fa fa-bullseye fa-3x" aria-hidden="true"></i>
    </div>
    <h2>Our Mission</h2>
    <p>We strive to provide impactful programs in health, education, and environmental sustainability, fostering community development and long-term change across Africa.</p>
  </section>

  <!-- Footer -->
  <footer id="footer">
    <div class="footer-content container">
      <div class="footer-adress text-center col-xs-12 col-sm-4 col-md-4">
        <h4>Great love for humanity</h4>
        <ul class="footer-menus">
          <li>Home /</li>
          <li>About</li><br />
          <li>Service /</li>
          <li>Gallery /</li>
          <li>Contact</li>
        </ul>
      </div>
      <div class="footer-second col-xs-12 col-sm-4 col-md-4">
        <div class="social-block text-center">
          <div class="social-share">
            <i class="fa fa-2x fa-facebook"></i>
            <i class="fa fa-2x fa-twitter"></i>
            <i class="fa fa-2x fa-google-plus"></i>
            <i class="fa fa-2x fa-instagram"></i>
          </div>
        </div>
        <p class="text-center footer-text1">123 456 7890</p>
        <p class="text-center footer-text">humanity@shuvohabib.com</p>
      </div>
      <div class="footer-third col-xs-12 col-sm-4 col-md-4">
        <div class="copyright text-center">
          <span>&copy; 2025 Theme</span><br>
          <span>All Rights Reserved</span>
        </div>
      </div>
    </div>
  </footer>

  <!-- Scripts -->
  <script src="js/jquery.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
</body>
</html>
